// small JS: smooth scroll and contact handler
document.querySelectorAll('a[href^="#"]').forEach(a=>{
    a.addEventListener('click', e=>{
        const href = a.getAttribute('href');
        if(href.startsWith('#')){
            e.preventDefault();
            const el = document.querySelector(href);
            if(el) el.scrollIntoView({behavior:'smooth',block:'start'});
        }
    })
})

function handleContact(e){
    e.preventDefault();
    const f = e.target;
    const data = {name:f.name.value,email:f.email.value,subject:f.subject.value,message:f.message.value};
    // demo: show JSON — replace with real endpoint (Netlify Functions / Formspree / your backend)
    alert('送信内容のプレビュー:\n' + JSON.stringify(data, null, 2));
    f.reset();
}
// footer year
document.getElementById('year').textContent = new Date().getFullYear();

/* =========================
  ヘッダーメニュー
========================= */
const hamburger = document.getElementById("hamburger");
const nav = document.getElementById("nav");
if (hamburger) {
  hamburger.addEventListener("click", () => {
    nav.style.display = nav.style.display === "block" ? "none" : "block";
  });
}