from flask import render_template,Request
from models.base import db
from models.user import User

class UserServiceCls():
    
    #コンストラクタ
    def __init__(self):
        pass
    
    #初期表示
    def initUserObj(self):
        #ユーザー情報を取得
        user = User.query.get(1)
        return user
    
    #基本情報の更新
    def updateBaseInfo(self,requestInfo:Request):
         #ユーザー情報を取得
        user = User.query.get(1)
        #データが存在することを確認
        if not user:
            return False        
        #更新する値を設定
        user.user_name = requestInfo.form.get("user_name")
        user.user_initial_name = requestInfo.form.get("user_initial_name")
        user.site_explanation = requestInfo.form.get("site_explanation")
        user.engineer_type = requestInfo.form.get("engineer_type")
        user.engineer_skills = ",".join(requestInfo.form.getlist("engineer_skills"))
        #User情報更新
        return db.session.commit()
    
    #Aboutの更新
    def updateAboutInfo(self,requestInfo:Request):
         #ユーザー情報を取得
        user = User.query.get(1)
        #データが存在することを確認
        if not user:
            return False        
        #更新する値を設定
        user.user_explanation = requestInfo.form.get("user_explanation")
        #User情報更新
        return db.session.commit()

    #プロジェクト情報の更新
    def updateProjectsInfo(self,requestInfo:Request):
         #ユーザー情報を取得
        user = User.query.get(1)
        #データが存在することを確認
        if not user:
            return False        
        #更新する値を設定
        user.project_name1 = requestInfo.form.get("project_name1")
        user.project_explanation1 = requestInfo.form.get("project_explanation1")
        user.project_skills1 = ",".join(requestInfo.form.getlist("project_skills1"))
        user.project_name2 = requestInfo.form.get("project_name2")
        user.project_explanation2 = requestInfo.form.get("project_explanation2")
        user.project_skills2 = ",".join(requestInfo.form.getlist("project_skills2"))
        user.project_name3 = requestInfo.form.get("project_name3")
        user.project_explanation3 = requestInfo.form.get("project_explanation3")
        user.project_skills3 = ",".join(requestInfo.form.getlist("project_skills3"))
        #User情報更新
        return db.session.commit()

    #Contactの更新コントロール
    def updateContactInfo(self,requestInfo:Request):
         #ユーザー情報を取得
        user = User.query.get(1)
        #データが存在することを確認
        if not user:
            return False        
        #更新する値を設定
        user.user_mail_address = requestInfo.form.get("user_mail_address")
        user.user_job_area = requestInfo.form.get("user_job_area")
        #User情報更新
        return db.session.commit()