from flask import Flask
from flask import render_template, request, redirect, url_for
from models.base import db
from services.UserService import UserServiceCls
from config import Config

app = Flask(__name__ )
app.config.from_object(Config)

db.init_app(app)
   
class mainCtl():
    def __init__(self):
        app.run()
    
    #Home画面
    @app.route("/")
    def index():
        #ユーザー情報を取得してホーム画面に遷移します。
        userServiceCtrl = UserServiceCls()
        userObj = userServiceCtrl.initUserObj()
        return render_template("index.html",userObj=userObj)

    #編集画面
    @app.route("/edit")
    def edit():
        #ユーザー情報を取得して編集画面に遷移します。
        userServiceCtrl = UserServiceCls()
        userObj = userServiceCtrl.initUserObj()
        return render_template("edit.html",userObj=userObj)
    
    #更新処理(基本)
    @app.route("/base_update",methods=["POST"])
    def base_update():
        #更新内容を取得してデータを更新する。
        userServiceCtrl = UserServiceCls()
        #Mapにして処理に渡す。
        dicUserInfo = request.form
        #基本情報の更新
        userServiceCtrl.updateBaseInfo(request)
        
        return redirect(url_for("edit"))

    #更新処理(Abount)
    @app.route("/about_update",methods=["POST"])
    def about_update():
        #更新内容を取得してデータを更新する。
        userServiceCtrl = UserServiceCls()
        #Mapにして処理に渡す。
        #Abount情報の更新
        userServiceCtrl.updateAboutInfo(request)
        
        return redirect(url_for("edit"))

    #更新処理(Projects)
    @app.route("/projects_update",methods=["POST"])
    def projects_update():
        #更新内容を取得してデータを更新する。
        userServiceCtrl = UserServiceCls()
        #Mapにして処理に渡す。
        #Abount情報の更新
        userServiceCtrl.updateProjectsInfo(request)
        
        return redirect(url_for("edit"))

    #更新処理(Abount)
    @app.route("/contact_update",methods=["POST"])
    def contact_update():
        #更新内容を取得してデータを更新する。
        userServiceCtrl = UserServiceCls()
        #Mapにして処理に渡す。
        #Abount情報の更新
        userServiceCtrl.updateContactInfo(request)
        
        return redirect(url_for("edit"))

if __name__ == '__main__':
   mainCtl()